#ifndef RTURTLE_H
#define RTURTLE_H

#include <raylib.h>
#include "rdrawing.h"

/**
 * Press F2 toggle display of grids
 * Press F3 toggle display of the turtle 
 * Press F5 to capture screen
 */

typedef struct
{
	double x;
	double y;
	double angle;
	bool is_pen_down;
	Color pen_color;
	int pen_size;
} TurtleState;

#if defined(__cplusplus)
extern "C" {            // Prevents name mangling of functions
#endif

	//prepare the turtle world
	void initWorld(int width,int height);
	void closeWorld();
	
	//let the turtle move (animated)
	void fd(double step);
	void forward(double step);
	void bk(double step);
	void backward(double step);	
	void lt(double degree);
	void leftTurn(double degree);	
	void rt(double degree);
	void rightTurn(double degree);
	void turnTo(double angle);
	void faceXY(double x,double y);	
	void gotoXY(double x, double y);

	//move turtle to draw a circle arc
	void arc(double radius, int degree);	

	
	//change turtle's position or heading (no animation)
	void setXY(double x, double y);
	void setX(double x);
	void setY(double y);
	void setAngle(double angle);
	void setHeading(double angle);	

	//set turtle back to the origin (no animation)
	void home();
	
	//clear screen and set turtle back to the origin
	void cs();
	void clearScreen();
	
	//clear screen but don't set turtle back
	void clear();

	//get turtle's position or heading
	Vector2 getXY();
	double getX();
	double getY();
	double getAngle();
	double getHeading();
	
	//fill the polygon generated by turtle's move 
	void beginFill();
	void endFill(Color fillColor);
	int isFilling();
	
	void beginPoly();
	void endPoly();
	
	//flood fill the whole area that has the same color with turtle's current position.
	void fill(Color fillColor);
	
	//flood fill the area that turtle is in it and is enclosed by borders that has the borderColor. 
	void fillToBorder(Color borderColor, Color fillColor);
	
	//set/get turtle's state
	TurtleState getState();
	void setState(TurtleState state);
	
	//set/get turtle's visibility
	void hide();
	void show();
	void setVisible(bool visible);
	bool isVisible();

	//set/get drawing paramenters
	void pd();
	void pu();
	void penDown();
	void penUp();
	void setPenDown(bool isDown);
	bool isPenDown();
	void setPenSize(int size);
	int getPenSize();
	void setPenColor(Color color);
	Color getPenColor();
	void setRewind(bool isRewind);
	bool isRewind();

	//set/get animation speed
	void setSpeed(int speed);
	int getSpeed();
	void setImmediate(bool isImmediate);
	bool isImmediate();
	
	//pause functions 
	void waitClick();
	void waitClose();
	void waitMilliseconds(int ms);
	
	//set world's state
	//set origin's position 
	void setOrigin(int x, int y);
	
	//caption/title should be utf-8 encoded.
	void setCaption(const char* title);
	
	//background
	void setBackgroundImage(Image backImg);
	int setBackgroundImageFile(const char* filename);
	void hideBackgroundImage();
	void unhideBackgroundImage();
	void setBackgroundColor(Color color);
	Color getBackgroundColor();
	
	//grid lines (press F2 to switch them on/off)
	void createGrids(int gridSize, int gridLineWidth, int labelFontSize, Color gridColorX, Color gridColorY);
	void removeGrids();

	//manual update mode
	void setAutoUpdateWorld(bool isAutoUpdate);
	bool isAutoUpdateWorld();
	void updateWorld();
	
	//2d drawing functions
	void drawPoint(int x, int y);
	void drawLine(int x0, int y0, int x1, int y1);
	void drawEllipse(int centerX, int centerY, int radiusX, int radiusY);
	void fillEllipse(int centerX, int centerY, int radiusX, int radiusY, Color fillColor);

	//utitily functions
	double randBetween(double start,double end);
	
#if defined(__cplusplus)
}            // Prevents name mangling of functions
#endif

#endif
